<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Notification;

use Erlage\Photogram\Data\Dtos\Notification\NotificationLinkedContentDTO;

trait TraitNotificationSetters
{
    use TraitNotificationProperties;

    /**
     * @return static 
     */
    public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setToUserId(string $toUserId)
    {
        $this -> toUserId = $toUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setTargetContentId(string $targetContentId)
    {
        $this -> targetContentId = $targetContentId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setLinkedContent(NotificationLinkedContentDTO $linkedContent)
    {
        $this -> linkedContent = $linkedContent;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaType(string $metaType)
    {
        $this -> metaType = $metaType;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaIsRead(string $metaIsRead)
    {
        $this -> metaIsRead = $metaIsRead;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaIsTransient(string $metaIsTransient)
    {
        $this -> metaIsTransient = $metaIsTransient;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistrationDate(string $stampRegistrationDate)
    {
        $this -> stampRegistrationDate = $stampRegistrationDate;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
